<?php

use phpformbuilder\Form;

session_start();
require_once '../phpformbuilder/autoload.php';
require_once __DIR__ . '/code-samples-functions.php';

$contentText = array();
$output       = array();
$outputCode  = array();
$phpCode     = array();

// Included frameworks
$contentText['included-frameworks'] = '<p class="lead">This document gives you quick examples of different layouts and form elements.</p>
<p>Most examples are displayed using Bootstrap 5 layout.<br>The other frameworks (<strong><em>Bootstrap 4</em></strong>, <strong><em>Bulma</em></strong>, <strong><em>Foundation</em></strong>, <strong><em>Material Design</em></strong>, <strong><em>Tailwind</em></strong>, and <strong><em>uiKit</em></strong>) use the same markup.</p>
<p>The fourth argument defines the framework when you instantiate your form.</p>';

$phpCode['included-frameworks'][] = '// default Bootstrap 5 form
$form = new Form(\'form-name\', \'horizontal\', \'novalidate\');

// Bootstrap 4
$form = new Form(\'form-name\', \'horizontal\', \'novalidate\', \'bs4\');

// Bulma
$form = new Form(\'form-name\', \'horizontal\', \'novalidate\', \'bulma\');

// Foundation
$form = new Form(\'form-name\', \'horizontal\', \'novalidate\', \'foundation\');

// Material form (Materialize)
$form = new Form(\'form-name\', \'horizontal\', \'novalidate\', \'material\');

// Tailwind
$form = new Form(\'form-name\', \'horizontal\', \'novalidate\', \'tailwind\');

// uiKit
$form = new Form(\'form-name\', \'horizontal\', \'novalidate\', \'uikit\');';

// No framework
$contentText['no-framework'] = '<p>If your project is based on custom css or doesn\'t use any popular framework,<br><strong>a minimal Bootstrap 5 CSS is provided</strong> in <span class="file-path">phpformbuilder/templates/assets/bootstrap5-phpfb/</span>.</p><p>It includes only the strict minimum to build responsive forms.</p><p>Link this CSS file to your page and you can then create Bootstrap 5 forms without breaking anything from your design.</p>';

$output['no-framework'] = '';
$outputCode['no-framework'] = '';
$phpCode['no-framework'][] = '&lt;head&gt;
// link to the minimal Bootstrap 5 CSS
&lt;link rel=&quot;stylesheet&quot; href=&quot;/phpformbuilder/templates/assets/bootstrap5-phpfb/css/bootstrap5-phpfb.min.css&quot;&gt;
&lt;/head&gt;
&lt;?php
// Then you can build your form
$form = new Form(\'my-form\', \'horizontal\', \'novalidate\');';

// Customize for other frameworks
$contentText['customize-for-other-frameworks'] =
'<p>Each framework has its specific markup and CSS classes. For example, some frameworks wrap radio buttons &amp; checkboxes into their label, whereas others don\'t.<p>
<p>Bootstrap adds a CSS <em>form-control</em> class to the form elements, but other frameworks don\'t.</p>
<p>The <code>options</code> property of the form defines all these specificities, including responsive rows & columns., including responsive rows &amp; columns.</p>
<p><strong>The HTML code generated by PHP Form Builder can be easily customized for any framework:<br>Semantic-UI, Pure, Skeleton, UIKit, Milligram, Susy, ...</strong></p><p>See details of options here: <a href="class-doc.php#options-overview">class-doc.php#options-overview</a></p>';
$phpCode['customize-for-other-frameworks'][] = '$customOptions = array(
    // options here
);
$form->setOptions($customOptions);';

// Horizontal forms
$contentText['horizontal-forms'] = '<p>The horizontal forms display labels and fields in two responsive columns whose width you can define.</p>';

$form = new Form('my-form', 'horizontal', 'novalidate');

// 3 columns label, 9 columns field, breakpoint = small screens
$form->setCols(3, 9, 'sm');

$form->addInput('text', 'user-name', '', 'User Name', 'required');

$phpCode['horizontal-forms'][] = '$form = new Form(\'my-form\', \'horizontal\', \'novalidate\');

// 3 columns label, 9 columns field, breakpoint = small screens
$form->setCols(3, 9, \'sm\');

$form->addInput(\'text\', \'user-name\', \'\', \'User Name\', \'required\');';
$output['horizontal-forms'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['horizontal-forms'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

// Vertical forms
$contentText['vertical-forms'] = '<p>In vertical forms, labels are displayed above the fields. Vertical forms don\'t use columns.</p>';

$form = new Form('my-form', 'vertical', 'novalidate');
$form->addInput('text', 'user-name', '', 'User Name', 'required');

$phpCode['vertical-forms'][] = '$form = new Form(\'my-form\', \'vertical\', \'novalidate\');
$form->addInput(\'text\', \'user-name\', \'\', \'User Name\', \'required\');';
$output['vertical-forms'][] = '<form>' . $form->html . '</form>';
$outputCode['vertical-forms'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

// Inline forms
$contentText['inline-forms'] = '<p>Inline forms display labels and fields on the same line without containers.</p><p>To do this, create your form in horizontal mode and group your fields, or use input addons.</p>';

$form = new Form('my-form', 'horizontal', 'novalidate');
$form->setCols(-1, -1);
$form->addHeading('Elements grouped on the same line', 'h4');
$form->groupElements('user-firstname', 'user-name', 'submit-btn');
$form->addInput('text', 'user-firstname', '', '', 'placeholder=First name, required');
$form->addInput('text', 'user-name', '', '', 'placeholder=Name, required');
$form->addBtn('submit', 'submit-btn', 1, 'Submit', 'class=btn btn-primary');
$form->addHeading('Elements with addons', 'h4', 'class=mt-5');
$addonHtml = '<button class="btn btn-primary" type="submit">Submit</button>';
$form->addAddon('search-input', $addonHtml, 'after');
$form->addInput('text', 'search-input', '', '', 'placeholder=Search ..., required');

$phpCode['inline-forms'][] = '$form = new Form(\'my-form\', \'horizontal\', \'novalidate\');
$form->setCols(-1, -1);
$form->addHeading(\'Elements grouped on the same line\', \'h4\');
$form->groupElements(\'user-firstname\', \'user-name\', \'submit-btn\');
$form->addInput(\'text\', \'user-firstname\', \'\', \'\', \'placeholder=First name, required\');
$form->addInput(\'text\', \'user-name\', \'\', \'\', \'placeholder=Name, required\');
$form->addBtn(\'submit\', \'submit-btn\', 1, \'Submit\', \'class=btn btn-primary\');
$form->addHeading(\'Elements with addons\', \'h4\', \'class=mt-5\');
$addonHtml = \'&lt;button class=&quot;btn btn-primary&quot; type=&quot;submit&quot;&gt;Submit&lt;/button&gt;\';
$form->addAddon(\'search-input\', $addonHtml, \'after\');
$form->addInput(\'text\', \'search-input\', \'\', \'\', \'placeholder=Search ..., required\');';
$output['inline-forms'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['inline-forms'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

// Input groups
$contentText['input-groups'] = '<p>Input groups allow you to group several fields in the same row.</p>
<p>It is only possible in horizontal forms, which are the only ones to use a responsive layout with columns and rows.</p>';

$form = new Form('my-form', 'horizontal', 'novalidate');

// 2 columns label, 4 columns field, breakpoint = small screens
$form->setCols(2, 4, 'sm');

$form->groupElements('user-name', 'user-first-name');

$form->addInput('text', 'user-name', '', 'Name', 'required');
$form->addInput('text', 'user-first-name', '', 'First name');

$phpCode['input-groups'][] = '$form = new Form(\'my-form\', \'horizontal\', \'novalidate\');

// 2 columns label, 4 columns field, breakpoint = small screens
$form->setCols(2, 4, \'sm\');

$form->groupElements(\'user-name\', \'user-first-name\');

$form->addInput(\'text\', \'user-name\', \'\', \'Name\', \'required\');
$form->addInput(\'text\', \'user-first-name\', \'\', \'First name\');';
$output['input-groups'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['input-groups'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

// Columns
$contentText['columns'] = '<p>To create a 2-column form, insert the html code in the appropriate places using the <code>startRow()</code>, <code>startCol()</code>, <code>endRow()</code>, <code>endCol()</code> functions.</p>';

$form = new Form('my-form', 'vertical', 'novalidate');

$form->startRow();
$form->startCol(6);

$form->addInput('text', 'user-name', '', 'Name', 'required');
$form->addInput('text', 'user-first-name', '', 'First Name', 'required');

$form->endCol();
$form->startCol(6);

$form->addInput('email', 'user-email', '', 'Email', 'required');
$form->addInput('tel', 'user-phone', '', 'Phone', 'required');

$form->endCol();
$form->endRow();

$phpCode['columns'][] = '$form = new Form(\'my-form\', \'vertical\', \'novalidate\');

$form->startRow();
$form->startCol(6);

$form->addInput(\'text\', \'user-name\', \'\', \'Name\', \'required\');
$form->addInput(\'text\', \'user-first-name\', \'\', \'First Name\', \'required\');

$form->endCol();
$form->startCol(6);

$form->addInput(\'email\', \'user-email\', \'\', \'Email\', \'required\');
$form->addInput(\'tel\', \'user-phone\', \'\', \'Phone\', \'required\');

$form->endCol();
$form->endRow();';
$output['columns'][] = '<form>' . $form->html . '</form>';
$outputCode['columns'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

// Layout (Columns)
$contentText['layout'] = '<div class="mb-md">';
$contentText['layout'] .= '<p><strong>Layout is based on a Bootstrap 12 columns grid.</strong></p>';
$contentText['layout'] .= '<p><strong>setCols</strong> function sets labels and fields\'s number of columns.</p>';
$contentText['layout'] .= '<p><strong>Default is 4 columns labels and 8 columns fields.</strong></p>';
$contentText['layout'] .= '</div>';

$phpCode['layout'][] = '// set 3 columns labels and 9 columns fields
$form->setCols(3, 9);

// set no label (or Material floating label + 12 columns fields
$form->setCols(0, 12);';

// Input with label
$form = new Form('my-form', 'horizontal', 'novalidate');
$form->addInput('text', 'user-name-1', 'value', 'User Name', 'required');

$phpCode['input-with-label'][] = '$form->addInput(\'text\', \'user-name-1\', \'value\', \'User Name\', \'required\');';
$output['input-with-label'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['input-with-label'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

// Input with placeholder
$form = new Form('my-form', 'horizontal', 'novalidate');
$form->addInput('text', 'user-name-2', '', 'User Name', 'placeholder=Your Name, required');

$phpCode['input-with-placeholder'][] = '$form->addInput(\'text\', \'user-name-2\', \'\', \'User Name\', \'placeholder=Your Name, required\');';
$output['input-with-placeholder'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['input-with-placeholder'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

// Input with icon
$form = new Form('my-form', 'horizontal', 'novalidate');
$form->addIcon('user-name-3', '<span class="bi bi-person-fill"></span>', 'before');
$form->addInput('text', 'user-name-3', '', 'User Name', 'placeholder=Your Name, required');

$phpCode['input-with-icon'][] = '$form->addIcon(\'user-name-3\', \'&lt;span class=&quot;bi bi-person-fill&quot;&gt;&lt;/span&gt;\', \'before\');
$form->addInput(\'text\', \'user-name-3\', \'\', \'User Name\', \'placeholder=Your Name, required\');';
$output['input-with-icon'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['input-with-icon'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

// input with button addon

$phpCode['input-with-button-addon'][] = '// See examples with code in templates';
$output['input-with-button-addon'][] = '<p>See examples with code in templates:</p>
<ul>
<li><a href="https://www.phpformbuilder.pro/templates/bootstrap-4-forms/input-with-addons.php">https://www.phpformbuilder.pro/templates/bootstrap-4-forms/input-with-addons.php</a></li>
<li><a href="https://www.phpformbuilder.pro/templates/bootstrap-5-forms/input-with-addons.php">https://www.phpformbuilder.pro/templates/bootstrap-5-forms/input-with-addons.php</a></li>
<li><a href="https://www.phpformbuilder.pro/templates/bulma-forms/input-with-addons.php">https://www.phpformbuilder.pro/templates/bulma-forms/input-with-addons.php</a></li>
<li><a href="https://www.phpformbuilder.pro/templates/foundation-forms/input-with-addons.php">https://www.phpformbuilder.pro/templates/foundation-forms/input-with-addons.php</a></li>
<li><a href="https://www.phpformbuilder.pro/templates/material-bootstrap-forms/input-with-addons.php">https://www.phpformbuilder.pro/templates/material-bootstrap-forms/input-with-addons.php</a></li>
<li><a href="https://www.phpformbuilder.pro/templates/material-forms/input-with-addons.php">https://www.phpformbuilder.pro/templates/material-forms/input-with-addons.php</a></li>
<li><a href="https://www.phpformbuilder.pro/templates/material-forms/input-with-addons.php">https://www.phpformbuilder.pro/templates/material-forms/input-with-addons.php</a></li>
<li><a href="https://www.phpformbuilder.pro/templates/tailwind-forms/input-with-addons.php">https://www.phpformbuilder.pro/templates/tailwind-forms/input-with-addons.php</a></li>
<li><a href="https://www.phpformbuilder.pro/templates/uikit-forms/input-with-addons.php">https://www.phpformbuilder.pro/templates/uikit-forms/input-with-addons.php</a></li>
</ul>';
$outputCode['input-with-button-addon'][] = '// See examples with code in templates';

// Input without label
$form = new Form('my-form', 'horizontal', 'novalidate');
$form->setCols(0, 12);
$form->addIcon('user-name-4', '<span class="bi bi-person-fill"></span>', 'before');
$form->addInput('text', 'user-name-4', '', '', 'placeholder=Your Name, required');

$phpCode['input-without-label'][] = '$form->setCols(0, 12);
$form->addIcon(\'user-name-4\', \'<span class="bi bi-person-fill"></span>\', \'before\');
$form->addInput(\'text\', \'user-name-4\', \'\', \'\', \'placeholder=Your Name, required\');';
$output['input-without-label'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['input-without-label'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

// Input with a floating label (Material)
$form = new Form('my-form', 'horizontal', 'novalidate', 'material');
$form->setCols(0, 12);
$form->addInput('text', 'user-name-5', '', 'Your Name', 'required');

$phpCode['input-with-floating-label'][] = '$form = new Form(\'my-form\', \'horizontal\', \'novalidate\', \'material\');
$form->setCols(0, 12);
$form->addInput(\'text\', \'user-name-5\', \'\', \'Your Name\', \'required\');';
$output['input-with-floating-label'][] = '<p>See examples with code in <a href="https://www.phpformbuilder.pro/templates/index.php?framework=material" target="_blank">Material templates</a></p>';
$outputCode['input-with-floating-label'][] = '// See examples with code in Material templates';

// Several fields on the same line
$form = new Form('my-form', 'horizontal', 'novalidate');
$form->setCols(0, 6);
$form->groupElements('user-name-6', 'user-first-name-6');
$form->addIcon('user-name-6', '<span class="bi bi-person-fill"></span>', 'before');
$form->addInput('text', 'user-name-6', '', '', 'required=required, placeholder=Name*');
$form->addInput('text', 'user-first-name-6', '', '', 'placeholder=First Name');

$phpCode['several-fields-on-same-line'][] = '$form->setCols(0, 6);
$form->groupElements(\'user-name-6\', \'user-first-name-6\');
$form->addIcon(\'user-name-6\', \'<span class="bi bi-person-fill"></span>\', \'before\');
$form->addInput(\'text\', \'user-name-6\', \'\', \'\', \'required=required, placeholder=Name*\');
$form->addInput(\'text\', \'user-first-name-6\', \'\', \'\', \'placeholder=First Name\');';
$output['several-fields-on-same-line'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['several-fields-on-same-line'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

$form = new Form('my-form', 'horizontal', 'novalidate');
$form->startFieldset('Please fill the form below');
$form->setCols(4, 4);
$form->groupElements('first-name-1', 'last-name-1');
$form->addHelper('First name', 'first-name-1');
$form->addInput('text', 'first-name-1', '', 'Full Name : ', 'required=required');
$form->setCols(0, 4);
$form->addHelper('Last name', 'last-name-1');
$form->addInput('text', 'last-name-1', '', '', 'required=required');
$form->endFieldset();

$phpCode['several-fields-on-same-line'][] = '$form->startFieldset(\'Please fill the form below\');
$form->setCols(4, 4);
$form->groupElements(\'first-name-1\', \'last-name-1\');
$form->addHelper(\'First name\', \'first-name-1\');
$form->addInput(\'text\', \'first-name-1\', \'\', \'Full Name : \', \'required=required\');
$form->setCols(0, 4);
$form->addHelper(\'Last name\', \'last-name-1\');
$form->addInput(\'text\', \'last-name-1\', \'\', \'\', \'required=required\');
$form->endFieldset();';
$output['several-fields-on-same-line'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['several-fields-on-same-line'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

// Textarea
$form = new Form('my-form', 'horizontal', 'novalidate');
$form->addTextarea('special-request', '', 'Any Special Request?');

$phpCode['textarea'][] = '$form->addTextarea(\'special-request\', \'\', \'Any Special Request?\');';
$output['textarea'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['textarea'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

// Select
$form = new Form('my-form', 'horizontal', 'novalidate');
$form->addOption('prefix', '', 'Choose one ...', '', 'disabled, selected');
$form->addOption('prefix', 'Mr', 'Mr');
$form->addOption('prefix', 'Mrs', 'Mrs');
$form->addSelect('prefix', 'Full Name', 'required=required');

$phpCode['select'][] = '$form->addOption(\'prefix\', \'\', \'Choose one ...\', \'\', \'disabled, selected\');
$form->addOption(\'prefix\', \'Mr\', \'Mr\');
$form->addOption(\'prefix\', \'Mrs\', \'Mrs\');
$form->addSelect(\'prefix\', \'Full Name\', \'required=required\');';
$output['select'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['select'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

$form = new Form('my-form', 'horizontal', 'novalidate');
$form->addOption('favourite-animal', '', 'Choose one ...', '', 'disabled');
$form->addOption('favourite-animal', 'Dog', 'dog', 'Pets');
$form->addOption('favourite-animal', 'cat', 'Cat', 'Pets');
$form->addOption('favourite-animal', 'rabbit', 'Rabbit', 'Pets', 'selected=selected');
$form->addOption('favourite-animal', 'lion', 'Lion', 'Wild');
$form->addOption('favourite-animal', 'mouse', 'Mouse', 'Others');
$form->addOption('favourite-animal', 'mammoth', 'Mammoth', 'Others');
$form->addOption('favourite-animal', 'duck', 'Duck', 'Others');
$form->addSelect('favourite-animal', 'Favourite animal');
$phpCode['select'][] = '$form->addOption(\'favourite-animal\', \'Dog\', \'dog\', \'Pets\');
$form->addOption(\'favourite-animal\', \'cat\', \'Cat\', \'Pets\');
$form->addOption(\'favourite-animal\', \'rabbit\', \'Rabbit\', \'Pets\', \'selected=selected\');
$form->addOption(\'favourite-animal\', \'lion\', \'Lion\', \'Wild\');
$form->addOption(\'favourite-animal\', \'mouse\', \'Mouse\', \'Others\');
$form->addOption(\'favourite-animal\', \'mammoth\', \'Mammoth\', \'Others\');
$form->addOption(\'favourite-animal\', \'duck\', \'Duck\', \'Others\');
$form->addSelect(\'favourite-animal\', \'Favourite animal\');';
$output['select'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['select'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

$form = new Form('my-form', 'horizontal', 'novalidate');
$form->addOption('favourite-animal-2[]', 'Dog', 'dog');
$form->addOption('favourite-animal-2[]', 'cat', 'Cat');
$form->addOption('favourite-animal-2[]', 'lion', 'Lion');
$form->addOption('favourite-animal-2[]', 'mouse', 'Mouse');
$form->addOption('favourite-animal-2[]', 'mammoth', 'Mammoth');
$form->addOption('favourite-animal-2[]', 'duck', 'Duck');
$form->addOption('favourite-animal-2[]', 'rabbit', 'Rabbit');
$form->addSelect('favourite-animal-2[]', 'Favourite animal', 'multiple');
$form->addHelper('(multiple choices)', 'favourite-animal-2[]');

$phpCode['select'][] = '$form->addOption(\'favourite-animal-2[]\', \'Dog\', \'dog\');
$form->addOption(\'favourite-animal-2[]\', \'cat\', \'Cat\');
$form->addOption(\'favourite-animal-2[]\', \'lion\', \'Lion\');
$form->addOption(\'favourite-animal-2[]\', \'mouse\', \'Mouse\');
$form->addOption(\'favourite-animal-2[]\', \'mammoth\', \'Mammoth\');
$form->addOption(\'favourite-animal-2[]\', \'duck\', \'Duck\');
$form->addOption(\'favourite-animal-2[]\', \'rabbit\', \'Rabbit\');
$form->addSelect(\'favourite-animal-2[]\', \'Favourite animal\', \'multiple\');
$form->addHelper(\'(multiple choices)\', \'favourite-animal-2[]\');';
$output['select'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['select'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

// Radio
$form = new Form('my-form', 'horizontal', 'novalidate');
$form->addRadio('support-rating', 'Excellent', 'Excellent');
$form->addRadio('support-rating', 'Good', 'Good', 'checked=checked');
$form->addRadio('support-rating', 'Fair', 'Fair');
$form->addRadio('support-rating', 'Terrible', 'Terrible');
$form->printRadioGroup('support-rating', 'Please rate our support', false, 'required=required');

$phpCode['radio'][] = '$form->addRadio(\'support-rating\', \'Excellent\', \'Excellent\');
$form->addRadio(\'support-rating\', \'Good\', \'Good\', \'checked=checked\');
$form->addRadio(\'support-rating\', \'Fair\', \'Fair\');
$form->addRadio(\'support-rating\', \'Terrible\', \'Terrible\');
$form->printRadioGroup(\'support-rating\', \'Please rate our support\', false, \'required=required\');';
$output['radio'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['radio'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

$form = new Form('my-form', 'horizontal', 'novalidate');
$form->addRadio('support-rating-2', 'Excellent', 'Excellent');
$form->addRadio('support-rating-2', 'Good', 'Good', 'checked=checked');
$form->addRadio('support-rating-2', 'Fair', 'Fair');
$form->addRadio('support-rating-2', 'Terrible', 'Terrible');
$form->printRadioGroup('support-rating-2', 'Please rate our support', true, 'required=required');

$phpCode['radio'][] = '$form->addRadio(\'support-rating-2\', \'Excellent\', \'Excellent\');
$form->addRadio(\'support-rating-2\', \'Good\', \'Good\', \'checked=checked\');
$form->addRadio(\'support-rating-2\', \'Fair\', \'Fair\');
$form->addRadio(\'support-rating-2\', \'Terrible\', \'Terrible\');
$form->printRadioGroup(\'support-rating-2\', \'Please rate our support\', true, \'required=required\');';
$output['radio'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['radio'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

// Checkbox
$form = new Form('my-form', 'horizontal', 'novalidate');
$form->addCheckbox('favourite-animal-3', 'Dog', 'dog');
$form->addCheckbox('favourite-animal-3', 'cat', 'Cat');
$form->addCheckbox('favourite-animal-3', 'duck', 'Duck');
$form->addCheckbox('favourite-animal-3', 'rabbit', 'Rabbit');
$form->printCheckboxGroup('favourite-animal-3', 'Favourite animal');

$phpCode['checkbox'][] = '$form->addCheckbox(\'favourite-animal-3\', \'Dog\', \'dog\');
$form->addCheckbox(\'favourite-animal-3\', \'cat\', \'Cat\');
$form->addCheckbox(\'favourite-animal-3\', \'duck\', \'Duck\');
$form->addCheckbox(\'favourite-animal-3\', \'rabbit\', \'Rabbit\');
$form->printCheckboxGroup(\'favourite-animal-3\', \'Favourite animal\');';
$output['checkbox'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['checkbox'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

$form = new Form('my-form', 'horizontal', 'novalidate');
$form->addCheckbox('favourite-animal-4', 'Dog', 'dog');
$form->addCheckbox('favourite-animal-4', 'cat', 'Cat');
$form->addCheckbox('favourite-animal-4', 'duck', 'Duck');
$form->addCheckbox('favourite-animal-4', 'rabbit', 'Rabbit');
$form->printCheckboxGroup('favourite-animal-4', 'Favourite animal', false);

$phpCode['checkbox'][] = '$form->addCheckbox(\'favourite-animal-4\', \'Dog\', \'dog\');
$form->addCheckbox(\'favourite-animal-4\', \'cat\', \'Cat\');
$form->addCheckbox(\'favourite-animal-4\', \'duck\', \'Duck\');
$form->addCheckbox(\'favourite-animal-4\', \'rabbit\', \'Rabbit\');
$form->printCheckboxGroup(\'favourite-animal-4\', \'Favourite animal\', false);';
$output['checkbox'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['checkbox'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

// Button
$form = new Form('my-form', 'horizontal', 'novalidate');
$form->addBtn('submit', 'submit-btn', 1, 'Send <span class="bi bi-envelope append"></span>', 'class=btn btn-success');

$contentText['button'] = '<p>Use <code>$form->centerContent();</code> to center buttons or button groups</p>';

$phpCode['button'][] = '$form->addBtn(\'submit\', \'submit-btn\', 1, \'Send &lt;span class=&quot;bi bi-envelope append&quot;&gt;&lt;/span&gt;\', \'class=btn btn-success\');';
$output['button'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['button'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

$form = new Form('my-form', 'horizontal', 'novalidate');
$form->setCols(0, 12);
$form->centerContent();
$form->addBtn('submit', 'submit-btn', 1, 'Send <span class="bi bi-envelope append"></span>', 'class=btn btn-success');

$phpCode['button'][] = '$form->setCols(0, 12);
$form->centerContent();
$form->addBtn(\'submit\', \'submit-btn\', 1, \'Send <span class="bi bi-envelope append"></span>\', \'class=btn btn-success\');';
$output['button'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['button'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

// Button group
$form = new Form('my-form', 'horizontal', 'novalidate');
$form->addBtn('submit', 'cancel-btn', 0, 'Cancel <span class="bi bi-x-circle-fill append"></span>', 'class=btn btn-danger', 'my-btn-group');
$form->addBtn('submit', 'submit-btn', 1, 'Send <span class="bi bi-envelope append"></span>', 'class=btn btn-success', 'my-btn-group');
$form->printBtnGroup('my-btn-group');

$contentText['button-group'] = '<p>Use <code>$form->centerContent();</code> to center buttons or button groups</p>';

$phpCode['button-group'][] = '$form->addBtn(\'submit\', \'cancel-btn\', 0, \'Cancel &lt;span class=&quot;bi bi-x-circle-fill append&quot;&gt;&lt;/span&gt;\', \'class=btn btn-danger\', \'my-btn-group\');
$form->addBtn(\'submit\', \'submit-btn\', 1, \'Send &lt;span class=&quot;bi bi-envelope append&quot;&gt;&lt;/span&gt;\', \'class=btn btn-success\', \'my-btn-group\');
$form->printBtnGroup(\'my-btn-group\');';
$output['button-group'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['button-group'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

// Alerts
$form = new Form('my-form', 'horizontal', 'novalidate');
$alert = Form::buildAlert('<strong>This is a danger alert example</strong>', 'bs5', 'danger');
$form->addHtml($alert);

$phpCode['alerts'][] = 'echo Form::buildAlert(\'<strong>This is a danger alert example</strong>\', \'bs5\', \'danger\');';
$output['alerts'][] = $form->html;
$outputCode['alerts'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

// Headings
$form = new Form('my-form', 'horizontal', 'novalidate');
$form->addHeading('Please fill in the form below.', 'h3', 'class=text-center fw-light');

$phpCode['headings'][] = '$form->addHeading(\'Please fill in the form below.\', \'h3\', \'class=text-center fw-light\');';
$output['headings'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['headings'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

// Custom HTML
$form = new Form('my-form', 'horizontal', 'novalidate');
$form->addHelper('Enter your name', 'name-8');
$form->addInput('text', 'name-8', '', 'Name');
$form->addHtml('<p class="alert alert-warning"><span class="bi bi-exclamation-triangle-fill"></span> Please read this !</p>');

$phpCode['custom-html'][] = '$form->addHelper(\'Enter your name\', \'name-8\');
$form->addInput(\'text\', \'name-8\', \'\', \'Name\');
$form->addHtml(\'&lt;p class=&quot;alert alert-warning&quot;&gt;&lt;span class=&quot;bi bi-exclamation-triangle-fill&quot;&gt;&lt;/span&gt; Please read this !&lt;/p&gt;\');';
$output['custom-html'][] = '<form class="form-horizontal">' . $form->html . '</form>';
$outputCode['custom-html'][] = trim(htmlspecialchars($form->cleanHtmlOutput($form->html)));

// Default Values
$userId = 1;
$_SESSION['user-form']['civility']        = 'Ms.';
$_SESSION['user-form']['user-name-8']       = 'Wilson';
$_SESSION['user-form']['user-first-name-8'] = 'Susan';
$_SESSION['user-form']['user-email-8']      = 'swilsone@squarespace.com';
$_SESSION['user-form']['validated']       = 1;
$formDefaultValues = new Form('user-form');
$formDefaultValues->startFieldset('Update User');
$formDefaultValues->addInput('hidden', 'user_id', 1);
$formDefaultValues->addRadio('civility', 'M.', 'M.');
$formDefaultValues->addRadio('civility', 'Mrs.', 'Mrs.');
$formDefaultValues->addRadio('civility', 'Ms.', 'Ms.');
$formDefaultValues->printRadioGroup('civility', 'Civility : ');
$formDefaultValues->addInput('text', 'user-name-8', '', 'Name', 'size=60, required=required');
$formDefaultValues->addInput('text', 'user-first-name-8', '', 'First Name', 'size=60, required=required');
$formDefaultValues->addInput('email', 'user-email-8', '', 'email : ', 'size=60, required=required');
$formDefaultValues->addRadio('validated', 'Yes', 1);
$formDefaultValues->addRadio('validated', 'No', 0);
$formDefaultValues->printRadioGroup('validated', 'Validated');
$formDefaultValues->addBtn('button', 'cancel', 0, '<span class="bi bi-x-circle-fill prepend"></span>Cancel', 'class=btn btn-warning', 'btn-group');
$formDefaultValues->addBtn('submit', 'submit', 1, 'Submit <span class="bi bi-check-circle-fill"></span>', 'class=btn btn-success', 'btn-group');
$formDefaultValues->printBtnGroup('btn-group');
$formDefaultValues->endFieldset();

$phpCode['default-values-from-db'][] = '&lt;?php
// We use the "classicmodels" database as a MySQL sample database.
// Download the SQL at https://www.phpformbuilder.pro/documentation/phpformbuildersampledatabase.sql.zip
// Original source: https://www.mysqltutorial.org/mysql-sample-database.aspx

use phpformbuilder\Form;
use phpformbuilder\Validator\Validator;
use Migliori\PowerLitePdo\Db;

$root = rtrim($_SERVER[&apos;DOCUMENT_ROOT&apos;], DIRECTORY_SEPARATOR);

/* =============================================
    start session and include the autoloader
============================================= */

session_start();
include_once $root . &apos;/phpformbuilder/autoload.php&apos;;

/* =============================================
    Database connection
============================================= */

$container = require_once $root . &apos;/phpformbuilder/vendor/migliori/power-lite-pdo/src/bootstrap.php&apos;;
$db = $container->get(Db::class);

/* =============================================
    validation if posted
============================================= */

if ($_SERVER[&quot;REQUEST_METHOD&quot;] == &quot;POST&quot; &amp;&amp; Form::testToken(&apos;db-form&apos;) === true) {
    // create validator &amp; auto-validate required fields
    $validator = Form::validate(&apos;db-form&apos;);

    // check for errors
    if ($validator-&gt;hasErrors()) {
        $_SESSION[&apos;errors&apos;][&apos;db-form&apos;] = $validator-&gt;getAllErrors();
    } else {
        // Update the record
        $update = [
            &apos;productlines_id&apos;  =&gt; $_POST[&apos;productlines_id&apos;],
            &apos;code&apos;             =&gt; $_POST[&apos;code&apos;],
            &apos;name&apos;             =&gt; $_POST[&apos;name&apos;],
            &apos;description&apos;      =&gt; $_POST[&apos;description&apos;],
            &apos;stock&apos;            =&gt; $_POST[&apos;stock&apos;],
            &apos;price&apos;            =&gt; $_POST[&apos;price&apos;]
        ];
        $where = [
            &apos;id&apos; =&gt; $_POST[&apos;product_id&apos;]
        ];

        if (!$db-&gt;update(&apos;products&apos;, $update, $where)) {
            $msg = Form::buildAlert($db-&gt;error(), &apos;bs5&apos;, &apos;danger&apos;);
        } else {
            $msg = Form::buildAlert(&apos;Database updated successfully!&apos;, &apos;bs5&apos;, &apos;success&apos;);
        }
    }
}

/*=========================================================
  If no error is posted we get the values from the database
==========================================================*/

if (!isset($_SESSION[&apos;errors&apos;][&apos;db-form&apos;]) || empty($_SESSION[&apos;errors&apos;][&apos;db-form&apos;])) {
    if (isset($_GET[&apos;product_id&apos;]) &amp;&amp; is_numeric($_GET[&apos;product_id&apos;])) {
        $productId = $_GET[&apos;product_id&apos;];
    } else {
        // we set a random $productId for the demo
        $productId = rand(331, 440);
    }

    // we register the product_id to update the record later
    $_SESSION[&apos;db-form&apos;][&apos;product_id&apos;] = $productId;

    $row = $db-&gt;selectRow(&apos;products&apos;, &apos;productlines_id, products.code, products.name, products.description, products.stock, products.price&apos;, [&apos;products.id&apos; =&gt; $productId], false);

    // we register the record values to populate the form values
    $_SESSION[&apos;db-form&apos;][&apos;productlines_id&apos;]  = $row-&gt;productlines_id;
    $_SESSION[&apos;db-form&apos;][&apos;code&apos;]             = $row-&gt;code;
    $_SESSION[&apos;db-form&apos;][&apos;name&apos;]             = $row-&gt;name;
    $_SESSION[&apos;db-form&apos;][&apos;description&apos;]      = $row-&gt;description;
    $_SESSION[&apos;db-form&apos;][&apos;stock&apos;]            = $row-&gt;stock;
    $_SESSION[&apos;db-form&apos;][&apos;price&apos;]            = $row-&gt;price;
}

$form = new Form(&apos;db-form&apos;, &apos;horizontal&apos;, &apos;novalidate&apos;, &apos;bs5&apos;);
$form-&gt;setMode(&apos;development&apos;);

$form-&gt;addInput(&apos;hidden&apos;, &apos;product_id&apos;);
$form-&gt;startFieldset(&apos;Update Product&apos;, &apos;&apos;, &apos;class=text-center mb-4&apos;);

// get the product lines to populate the select options
$columns = array(&apos;id&apos;, &apos;name&apos;);
$db-&gt;select(&apos;productlines&apos;, $columns);

// loop through the results
while ($row = $db-&gt;fetch()) {
    $form-&gt;addOption(&apos;productlines_id&apos;, $row-&gt;id, $row-&gt;name);
}
$form-&gt;addSelect(&apos;productlines_id&apos;, &apos;Product line&apos;, &apos;data-slimselect=true, required&apos;);

$form-&gt;addInput(&apos;text&apos;, &apos;code&apos;, &apos;&apos;, &apos;Code&apos;, &apos;required&apos;);
$form-&gt;addInput(&apos;text&apos;, &apos;name&apos;, &apos;&apos;, &apos;Name&apos;, &apos;required&apos;);
$form-&gt;addInput(&apos;text&apos;, &apos;description&apos;, &apos;&apos;, &apos;Description&apos;, &apos;required&apos;);
$form-&gt;addInput(&apos;number&apos;, &apos;stock&apos;, &apos;&apos;, &apos;Stock&apos;, &apos;required&apos;);
$form-&gt;addAddon(&apos;price&apos;, &apos;&amp;euro;&apos;, &apos;after&apos;);
$form-&gt;addInput(&apos;number&apos;, &apos;price&apos;, &apos;&apos;, &apos;Price&apos;, &apos;required&apos;);
$form-&gt;setCols(0, 12);
$form-&gt;centerContent();
$form-&gt;addBtn(&apos;submit&apos;, &apos;submit-btn&apos;, 1, &apos;Submit&apos;, &apos;class=btn btn-primary mt-5, data-ladda-button=true, data-style=zoom-in&apos;, &apos;btn-group&apos;);
$form-&gt;endFieldset();
';
$output['default-values-from-db'][] = '<p>See examples with code in templates:</p>
<ul>
<li><a href="https://www.phpformbuilder.pro/templates/bootstrap-4-forms/default-db-values-form.php">https://www.phpformbuilder.pro/templates/bootstrap-4-forms/default-db-values-form.php</a></li>
<li><a href="https://www.phpformbuilder.pro/templates/bootstrap-5-forms/default-db-values-form.php">https://www.phpformbuilder.pro/templates/bootstrap-5-forms/default-db-values-form.php</a></li>
<li><a href="https://www.phpformbuilder.pro/templates/bulma-forms/default-db-values-form.php">https://www.phpformbuilder.pro/templates/bulma-forms/default-db-values-form.php</a></li>
<li><a href="https://www.phpformbuilder.pro/templates/foundation-forms/default-db-values-form.php">https://www.phpformbuilder.pro/templates/foundation-forms/default-db-values-form.php</a></li>
<li><a href="https://www.phpformbuilder.pro/templates/material-bootstrap-forms/default-db-values-form.php">https://www.phpformbuilder.pro/templates/material-bootstrap-forms/default-db-values-form.php</a></li>
<li><a href="https://www.phpformbuilder.pro/templates/material-forms/default-db-values-form.php">https://www.phpformbuilder.pro/templates/material-forms/default-db-values-form.php</a></li>
<li><a href="https://www.phpformbuilder.pro/templates/tailwind-forms/default-db-values-form.php">https://www.phpformbuilder.pro/templates/tailwind-forms/default-db-values-form.php</a></li>
<li><a href="https://www.phpformbuilder.pro/templates/uikit-forms/default-db-values-form.php">https://www.phpformbuilder.pro/templates/uikit-forms/default-db-values-form.php</a></li>
</ul>';
$outputCode['default-values-from-db'][] = '// See examples with code in templates';

// Default values from variables
if (!isset($_SESSION['errors']['test-form']) || empty($_SESSION['errors']['test-form'])) {
    // register default values
    $_SESSION['test-form']['civility-1'] = 'Ms.';
    $_SESSION['test-form']['user-name-9'] = 'Wilson';
    $_SESSION['test-form']['preferred-colors'] = array('blue', 'green');
}
$formValues = new Form('test-form', 'horizontal', 'novalidate');
$formValues->addRadio('civility-1', 'M.', 'M.');
$formValues->addRadio('civility-1', 'Mrs.', 'Mrs.');
$formValues->addRadio('civility-1', 'Ms.', 'Ms.');
$formValues->printRadioGroup('civility-1', 'Civility : ');
$formValues->addInput('text', 'user-name-9', '', 'Name', 'size=60, required');
$formValues->addOption('preferred-colors', 'red', 'red');
$formValues->addOption('preferred-colors', 'green', 'green');
$formValues->addOption('preferred-colors', 'yellow', 'yellow');
$formValues->addOption('preferred-colors', 'pink', 'pink');
$formValues->addOption('preferred-colors', 'blue', 'blue');
$formValues->addOption('preferred-colors', 'purple', 'purple');
$formValues->addOption('preferred-colors', 'black', 'black');
$formValues->addSelect('preferred-colors', 'Preferred colors', 'multiple');
$phpCode['default-values-variables'][] = '// Default values from variables
if (!isset($_SESSION[\'errors\'][\'test-form\']) || empty($_SESSION[\'errors\'][\'test-form\'])) {

// register default values
    $_SESSION[\'test-form\'][\'civility-1\'] = \'Ms.\';
    $_SESSION[\'test-form\'][\'user-name\'] = \'Wilson\';
    $_SESSION[\'test-form\'][\'preferred-colors\'] = array(\'blue\', \'green\');
}
$form = new Form(\'test-form\', \'horizontal\', \'novalidate\');
$form->addRadio(\'civility-1\', \'M.\', \'M.\');
$form->addRadio(\'civility-1\', \'Mrs.\', \'Mrs.\');
$form->addRadio(\'civility-1\', \'Ms.\', \'Ms.\');
$form->printRadioGroup(\'civility-1\', \'Civility : \');
$form->addInput(\'text\', \'user-name-9\', \'\', \'Name\', \'size=60, required\');
$form->addOption(\'preferred-colors\', \'red\', \'red\');
$form->addOption(\'preferred-colors\', \'green\', \'green\');
$form->addOption(\'preferred-colors\', \'yellow\', \'yellow\');
$form->addOption(\'preferred-colors\', \'pink\', \'pink\');
$form->addOption(\'preferred-colors\', \'blue\', \'blue\');
$form->addOption(\'preferred-colors\', \'purple\', \'purple\');
$form->addOption(\'preferred-colors\', \'black\', \'black\');
$form->addSelect(\'preferred-colors\', \'Preferred colors\', \'multiple\');
$form->render()';

$dfv = $formValues->getCode(false);
$output['default-values-variables'][] = $dfv;
$outputCode['default-values-variables'][] = trim(htmlspecialchars($form->cleanHtmlOutput($dfv)));

// Modal form
$contentText['modal-form'] = '<p>See examples with code here: </p><ul><li><a href="https://www.phpformbuilder.pro/documentation/javascript-plugins.php#modal-example">https://www.phpformbuilder.pro/documentation/javascript-plugins.php#modal-example</a></li><li><a href="https://www.phpformbuilder.pro/templates/index.php?forms=modal-form">Modal form templates</a></li></ul>';

// Popover form
$contentText['popover-form'] = '<p>See examples with code here: </p><ul><li><a href="https://www.phpformbuilder.pro/documentation/javascript-plugins.php#popover-example">https://www.phpformbuilder.pro/documentation/javascript-plugins.php#popover-example</a></li><li><a href="https://www.phpformbuilder.pro/templates/index.php?forms=popover-form">Popover form templates</a></li></ul>';

// Step form
$contentText['step-form'] = '<p>See examples with code here: <a href="https://www.phpformbuilder.pro/templates/index.php?forms=step">Step form templates</a></p>';

// Accordion form
$contentText['accordion-form'] = '<p>See examples with code here: <a href="https://www.phpformbuilder.pro/templates/index.php?forms=accordion">Step form templates</a></p>';

// validation
$contentText['validation'] = '<p><strong>Please refer to <a href="class-doc.php#validation-overview">class-doc.php#validation-overview</a></strong></p>';

// email-sending
$contentText['email-sending'] = '<p><strong>Please refer to <a href="class-doc.php#sendMail">class-doc.php#sendMail</a></strong></p>';

// email-sending
$contentText['anti-spam'] = '<p><strong>Please refer to <a href="javascript-plugins.php#altcha-example">javascript-plugins.php#altcha-example</a></strong></p>';

// database-crud
$contentText['database-crud'] = '<p><strong>Please refer to <a href="class-doc.php#database-main">class-doc.php#database-main</a></strong></p>';

$sections = array(
    'Frameworks' => array(
        array(
            'title' => 'Included frameworks',
            'anchor' => 'included-frameworks',
            'doc-link' => 'class-doc.php#frameworks'
        ),
        array(
            'title' => 'No framework',
            'anchor' => 'no-framework',
            'doc-link' => 'class-doc.php#no-framework'
        ),
        array(
            'title' => 'Customize for other frameworks',
            'anchor' => 'customize-for-other-frameworks',
            'doc-link' => 'class-doc.php#options-customizing'
        )
    ),
    'Layout' => array(
        array(
            'title' => 'Horizontal forms',
            'anchor' => 'horizontal-forms',
            'doc-link' => 'class-doc.php#construct'
        ),
        array(
            'title' => 'Vertical forms',
            'anchor' => 'vertical-forms',
            'doc-link' => 'class-doc.php#construct'
        ),
        array(
            'title' => 'Inline forms',
            'anchor' => 'inline-forms',
            'doc-link' => 'class-doc.php#construct'
        ),
        array(
            'title' => 'Input groups',
            'anchor' => 'input-groups',
            'doc-link' => 'class-doc.php#groupElements'
        ),
        array(
            'title' => 'Columns',
            'anchor' => 'columns',
            'doc-link' => 'class-doc.php#addHtml'
        )
    ),
    'Elements' => array(
        array(
            'title' => 'Input with label',
            'anchor' => 'input-with-label',
            'doc-link' => 'class-doc.php#addInput'
        ),
        array(
            'title' => 'Input with placeholder',
            'anchor' => 'input-with-placeholder',
            'doc-link' => 'class-doc.php#addInput'
        ),
        array(
            'title' => 'Input with icon',
            'anchor' => 'input-with-icon',
            'doc-link' => 'class-doc.php#add-icon'
        ),
        array(
            'title' => 'Input with button addon',
            'anchor' => 'input-with-button-addon',
            'doc-link' => ''
        ),
        array(
            'title' => 'Input without label',
            'anchor' => 'input-without-label',
            'doc-link' => 'class-doc.php#addInput'
        ),
        array(
            'title' => 'Input with a floating label (Material)',
            'anchor' => 'input-with-floating-label',
            'doc-link' => ''
        ),
        array(
            'title' => 'Several fields on the same line<br>(input groups)',
            'anchor' => 'several-fields-on-same-line',
            'doc-link' => ''
        ),
        array(
            'title' => 'Textarea',
            'anchor' => 'textarea',
            'doc-link' => ''
        ),
        array(
            'title' => 'Select',
            'anchor' => 'select',
            'doc-link' => 'class-doc.php#addSelect'
        ),
        array(
            'title' => 'Radio',
            'anchor' => 'radio',
            'doc-link' => 'class-doc.php#addRadio'
        ),
        array(
            'title' => 'Checkbox',
            'anchor' => 'checkbox',
            'doc-link' => 'class-doc.php#addCheckbox'
        ),
        array(
            'title' => 'Button',
            'anchor' => 'button',
            'doc-link' => 'class-doc.php#addBtn'
        ),
        array(
            'title' => 'Button group',
            'anchor' => 'button-group',
            'doc-link' => 'class-doc.php#printBtnGroup'
        )
    ),
    'Helpers' => array(
        array(
            'title' => 'Alerts',
            'anchor' => 'alerts',
            'doc-link' => 'class-doc.php#build-alert'
        ),
        array(
            'title' => 'Headings',
            'anchor' => 'headings',
            'doc-link' => 'class-doc.php#addHtml'
        ),
        array(
            'title' => 'Custom HTML',
            'anchor' => 'custom-html',
            'doc-link' => 'class-doc.php#add-heading'
        )
    ),
    'Default Values' => array(
        array(
            'title' => 'From database',
            'anchor' => 'default-values-from-db',
            'doc-link' => ''
        ),
        array(
            'title' => 'From variables',
            'anchor' => 'default-values-variables',
            'doc-link' => ''
        )
    ),
    'Special forms' => array(
        array(
            'title' => 'Modal form',
            'anchor' => 'modal-form',
            'doc-link' => ''
        ),
        array(
            'title' => 'Popover form',
            'anchor' => 'popover-form',
            'doc-link' => ''
        ),
        array(
            'title' => 'Step form',
            'anchor' => 'step-form',
            'doc-link' => ''
        ),
        array(
            'title' => 'Accordion form',
            'anchor' => 'accordion-form',
            'doc-link' => ''
        )
    ),
    'Misc' => array(
        array(
            'title' => 'Validation',
            'anchor' => 'validation',
            'doc-link' => 'class-doc.php#validation-examples'
        ),
        array(
            'title' => 'Email sending',
            'anchor' => 'email-sending',
            'doc-link' => 'class-doc.php#sendMail'
        ),
        array(
            'title' => 'Anti-spam',
            'anchor' => 'anti-spam',
            'doc-link' => 'javascript-plugins.php#altcha-example'
        ),
        array(
            'title' => 'Database CRUD',
            'anchor' => 'database-crud',
            'doc-link' => 'class-doc.php#database-main'
        )
    )
);

?>
<!doctype html>
<html lang="en-US">

<head>
    <?php
    $meta = array(
        'title'       => 'PHP Form Builder - Using functions and code samples',
        'description' => 'Examples of using PHP Form Builder functions to add fields to your forms, formatting them, managing the layout and using JavaScript plugins',
        'canonical'   => 'https://www.phpformbuilder.pro/documentation/code-samples.php',
        'screenshot'  => 'code-samples.png'
    );
    include_once 'inc/page-head.php';
    ?>
    <style> @font-face{ font-display: swap; font-family: Roboto; font-style: normal; font-weight: 300; src: local("Roboto Light"), local("Roboto-Light"), url('https://www.phpformbuilder.pro/documentation/assets/fonts/roboto-v18-latin-300.woff2') format("woff2"), url('https://www.phpformbuilder.pro/documentation/assets/fonts/roboto-v18-latin-300.woff') format("woff")} @font-face{ font-display: swap; font-family: Roboto; font-style: normal; font-weight: 400; src: local("Roboto"), local("Roboto-Regular"), url('https://www.phpformbuilder.pro/documentation/assets/fonts/roboto-v18-latin-regular.woff2') format("woff2"), url('https://www.phpformbuilder.pro/documentation/assets/fonts/roboto-v18-latin-regular.woff') format("woff")} @font-face{ font-display: swap; font-family: Roboto; font-style: normal; font-weight: 500; src: local("Roboto Medium"), local("Roboto-Medium"), url('https://www.phpformbuilder.pro/documentation/assets/fonts/roboto-v18-latin-500.woff2') format("woff2"), url('https://www.phpformbuilder.pro/documentation/assets/fonts/roboto-v18-latin-500.woff') format("woff")} @font-face{ font-display: swap; font-family: Roboto Condensed; font-style: normal; font-weight: 400; src: local("Roboto Condensed"), local("RobotoCondensed-Regular"), url('https://www.phpformbuilder.pro/documentation/assets/fonts/roboto-condensed-v16-latin-regular.woff2') format("woff2"), url('https://www.phpformbuilder.pro/documentation/assets/fonts/roboto-condensed-v16-latin-regular.woff') format("woff")} .output-code>pre:after{ background: #55524c; border-radius: 0 .25rem; color: #fff; font-family: Roboto; font-size: .8125rem; height: 24px; line-height: 24px; padding: 0 15px; position: absolute; right: 0; top: 0} .dmca-badge{ min-height: 100px} @font-face{ font-display: swap; font-family: bootstrap-icons; src: url('https://www.phpformbuilder.pro/documentation/assets/fonts/bootstrap-icons.woff2') format("woff2"), url('https://www.phpformbuilder.pro/documentation/assets/fonts/bootstrap-icons.woff') format("woff")} :root{ --bs-blue: #0e73cc; --bs-red: #fc4848; --bs-yellow: #ffc107; --bs-gray: #8c8476; --bs-gray-dark: #38352f; --bs-gray-100: #f6f6f5; --bs-gray-200: #eae8e5; --bs-gray-300: #d4d1cc; --bs-gray-400: #bfbab2; --bs-gray-500: #a9a398; --bs-gray-600: #7f7a72; --bs-gray-700: #55524c; --bs-gray-800: #2a2926; --bs-gray-900: #191817; --bs-primary: #0e73cc; --bs-secondary: #7f7a72; --bs-success: #0f9e7b; --bs-info: #00c2db; --bs-pink: #e6006f; --bs-warning: #ffc107; --bs-danger: #fc4848; --bs-light: #f6f6f5; --bs-dark: #191817; --bs-primary-rgb: 14, 115, 204; --bs-secondary-rgb: 127, 122, 114; --bs-success-rgb: 15, 158, 123; --bs-info-rgb: 0, 194, 219; --bs-pink-rgb: 230, 0, 111; --bs-warning-rgb: 255, 193, 7; --bs-danger-rgb: 252, 72, 72; --bs-light-rgb: 246, 246, 245; --bs-dark-rgb: 25, 24, 23; --bs-white-rgb: 255, 255, 255; --bs-black-rgb: 0, 0, 0; --bs-body-color-rgb: 42, 45, 45; --bs-body-bg-rgb: 255, 255, 255; --bs-font-sans-serif: Roboto, -apple-system, BlinkMacSystemFont, "Segoe UI", "Helvetica Neue", Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol"; --bs-font-monospace: Consolas, Monaco, Andale Mono, Ubuntu Mono, monospace; --bs-gradient: linear-gradient(180deg, hsla(0, 0%, 100%, .15), hsla(0, 0%, 100%, 0)); --bs-body-font-family: Roboto, -apple-system, BlinkMacSystemFont, Segoe UI, Helvetica Neue, Arial, sans-serif, Apple Color Emoji, Segoe UI Emoji, Segoe UI Symbol; --bs-body-font-size: 0.9375rem; --bs-body-font-weight: 400; --bs-body-line-height: 1.5; --bs-body-color: #2a2d2d; --bs-body-bg: #fff} *, :after, :before{ box-sizing: border-box} @media (prefers-reduced-motion:no-preference){ :root{ scroll-behavior: smooth}} body{ -webkit-text-size-adjust: 100%; background-color: var(--bs-body-bg); color: var(--bs-body-color); font-family: var(--bs-body-font-family); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); line-height: var(--bs-body-line-height); margin: 0; text-align: var(--bs-body-text-align)} .h4, h1, h2, h3{ font-weight: 500; line-height: 1.2; margin-bottom: .5rem; margin-top: 0} h1{ font-size: calc(1.375rem + 1.5vw)} @media (min-width:1200px){ h1{ font-size: 2.5rem}} h2{ font-size: calc(1.3125rem + .75vw)} @media (min-width:1200px){ h2{ font-size: 1.875rem}} h3{ font-size: calc(1.28906rem + .46875vw)} .h4{ font-size: calc(1.26563rem + .1875vw)} @media (min-width:1200px){ h3{ font-size: 1.640625rem} .h4{ font-size: 1.40625rem}} p{ margin-bottom: 1rem; margin-top: 0} ul{ padding-left: 2rem} ul{ margin-bottom: 1rem; margin-top: 0} strong{ font-weight: bolder} a{ color: #0e73cc; text-decoration: underline} code, pre{ direction: ltr; font-family: Consolas, Monaco, Andale Mono, Ubuntu Mono, monospace; font-size: 1em; unicode-bidi: bidi-override} pre{ display: block; font-size: .875em; margin-bottom: 1rem; margin-top: 0; overflow: auto} pre code{ color: inherit; font-size: inherit; word-break: normal} code{ word-wrap: break-word; color: #e6006f; font-size: .875em} img, svg{ vertical-align: middle} label{ display: inline-block} button{ border-radius: 0} button, input, optgroup{ font-family: inherit; font-size: inherit; line-height: inherit; margin: 0} button{ text-transform: none} [type=button], button{ appearance: button;-webkit-appearance: button} ::-moz-focus-inner{ border-style: none; padding: 0} ::-webkit-datetime-edit-day-field, ::-webkit-datetime-edit-fields-wrapper, ::-webkit-datetime-edit-hour-field, ::-webkit-datetime-edit-minute, ::-webkit-datetime-edit-month-field, ::-webkit-datetime-edit-text, ::-webkit-datetime-edit-year-field{ padding: 0} ::-webkit-inner-spin-button{ height: auto} [type=search]{ appearance: textfield;-webkit-appearance: textfield; outline-offset: -2px} ::-webkit-search-decoration{ -webkit-appearance: none} ::-webkit-color-swatch-wrapper{ padding: 0} ::file-selector-button{ font: inherit} ::-webkit-file-upload-button{ -webkit-appearance: button; font: inherit} .lead{ font-size: 1.171875rem; font-weight: 300} .list-unstyled{ list-style: none; padding-left: 0} .btn{ background-color: transparent; border: 1px solid transparent; border-radius: 0; color: #2a2d2d; display: inline-block; font-size: .9375rem; font-weight: 400; line-height: 1.5; padding: .375rem .75rem; text-align: center; text-decoration: none; vertical-align: middle} .btn-danger{ background-color: #fc4848; border-color: #fc4848; box-shadow: inset 0 1px 0 hsla(0, 0%, 100%, .15), 0 1px 1px rgba(0, 0, 0, .075); color: #000} .btn-outline-secondary{ border-color: #7f7a72; color: #7f7a72} .container, .container-fluid{ margin-left: auto; margin-right: auto; padding-left: var(--bs-gutter-x, .75rem); padding-right: var(--bs-gutter-x, .75rem); width: 100%} @media (min-width:576px){ .container{ max-width: 540px}} @media (min-width:768px){ .container{ max-width: 720px}} @media (min-width:992px){ .container{ max-width: 960px}} .form-text{ color: #7f7a72; font-size: .875em; margin-top: .25rem} .form-control{ -webkit-appearance: none; -moz-appearance: none; appearance: none; background-clip: padding-box; background-color: #fff; border: 1px solid #bfbab2; border-radius: 0; box-shadow: inset 0 1px 2px rgba(0, 0, 0, .075); color: #2a2d2d; display: block; font-size: .9375rem; font-weight: 400; line-height: 1.5; padding: .375rem .75rem; width: 100%} .form-control::-webkit-date-and-time-value{ height: 1.5em} .form-control::-moz-placeholder{ color: #7f7a72; opacity: 1} .form-control:-ms-input-placeholder{ color: #7f7a72; opacity: 1} .form-control::-webkit-file-upload-button{ -webkit-margin-end: .75rem; background-color: #eae8e5; border: 0 solid; border-color: inherit; border-inline-end-width: 1px; border-radius: 0; color: #2a2d2d; margin: -.375rem -.75rem; margin-inline-end: .75rem; padding: .375rem .75rem} .input-group{ align-items: stretch; display: flex; flex-wrap: wrap; position: relative; width: 100%} .input-group>.form-control{ flex: 1 1 auto; min-width: 0; position: relative; width: 1%} .input-group .btn{ position: relative; z-index: 2} .input-group:not(.has-validation)>:not(:last-child):not(.dropdown-toggle):not(.dropdown-menu){ border-bottom-right-radius: 0; border-top-right-radius: 0} .input-group>:not(:first-child):not(.dropdown-menu):not(.valid-tooltip):not(.valid-feedback):not(.invalid-tooltip):not(.invalid-feedback){ border-bottom-left-radius: 0; border-top-left-radius: 0; margin-left: -1px} .nav{ display: flex; flex-wrap: wrap; list-style: none; margin-bottom: 0; padding-left: 0} .nav-link{ color: #0e73cc; display: block; padding: .5rem 1rem; text-decoration: none} .nav-pills .nav-link{ background: 0 0; border: 0; border-radius: 0} .navbar{ align-items: center; display: flex; flex-wrap: wrap; justify-content: space-between; padding-bottom: .5rem; padding-top: .5rem; position: relative} .navbar>.container-fluid{ align-items: center; display: flex; flex-wrap: inherit; justify-content: space-between} .navbar-brand{ font-size: 1.171875rem; margin-right: 1rem; padding-bottom: 0; padding-top: 0; text-decoration: none; white-space: nowrap} .navbar-nav{ display: flex; flex-direction: column; list-style: none; margin-bottom: 0; padding-left: 0} .navbar-nav .nav-link{ padding-left: 0; padding-right: 0} .navbar-collapse{ align-items: center; flex-basis: 100%; flex-grow: 1} .navbar-toggler{ background-color: transparent; border: 1px solid transparent; border-radius: 0; font-size: 1.171875rem; line-height: 1; padding: .25rem .75rem} .navbar-toggler-icon{ background-position: 50%; background-repeat: no-repeat; background-size: 100%; display: inline-block; height: 1.5em; vertical-align: middle; width: 1.5em} @media (min-width:992px){ .navbar-expand-lg{ flex-wrap: nowrap; justify-content: flex-start} .navbar-expand-lg .navbar-nav{ flex-direction: row} .navbar-expand-lg .navbar-nav .nav-link{ padding-left: 1rem; padding-right: 1rem} .navbar-expand-lg .navbar-collapse{ display: flex !important; flex-basis: auto} .navbar-expand-lg .navbar-toggler{ display: none}} .navbar-light .navbar-toggler{ border-color: rgba(0, 0, 0, .1); color: rgba(0, 0, 0, .55)} .navbar-light .navbar-toggler-icon{ background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3E%3Cpath stroke='rgba(0, 0, 0, 0.55)' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3E%3C/svg%3E")} .navbar-dark .navbar-brand{ color: #fff} .navbar-dark .navbar-nav .nav-link{ color: hsla(0, 0%, 100%, .65)} .navbar-dark .navbar-nav .nav-link.active{ color: #fff} .navbar-dark .navbar-toggler{ border-color: hsla(0, 0%, 100%, .1); color: hsla(0, 0%, 100%, .65)} .navbar-dark .navbar-toggler-icon{ background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3E%3Cpath stroke='rgba(255, 255, 255, 0.65)' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3E%3C/svg%3E")} .collapse:not(.show){ display: none} .fixed-top{ top: 0} .fixed-top{ left: 0; position: fixed; right: 0; z-index: 1030} .visually-hidden{ clip: rect(0, 0, 0, 0) !important; border: 0 !important; height: 1px !important; margin: -1px !important; overflow: hidden !important; padding: 0 !important; position: absolute !important; white-space: nowrap !important; width: 1px !important} .d-flex{ display: flex !important} .d-none{ display: none !important} .w-100{ width: 100% !important} .flex-column{ flex-direction: column !important} .flex-wrap{ flex-wrap: wrap !important} .justify-content-end{ justify-content: flex-end !important} .justify-content-center{ justify-content: center !important} .justify-content-between{ justify-content: space-between !important} .align-items-start{ align-items: flex-start !important} .align-items-center{ align-items: center !important} .my-4{ margin-bottom: 1.5rem !important; margin-top: 1.5rem !important} .me-1{ margin-right: .25rem !important} .me-3{ margin-right: 1rem !important} .mb-2{ margin-bottom: .5rem !important} .mb-4{ margin-bottom: 1.5rem !important} .mb-6{ margin-bottom: 6.25rem !important} .mb-7{ margin-bottom: 12.5rem !important} .ms-2{ margin-left: .5rem !important} .ms-auto{ margin-left: auto !important} .p-2{ padding: .5rem !important} .p-4{ padding: 1.5rem !important} .px-0{ padding-left: 0 !important; padding-right: 0 !important} .px-2{ padding-left: .5rem !important; padding-right: .5rem !important} .py-2{ padding-bottom: .5rem !important; padding-top: .5rem !important} .pt-1{ padding-top: .25rem !important} .pb-5{ padding-bottom: 3rem !important} .pb-6{ padding-bottom: 6.25rem !important} .pb-7{ padding-bottom: 12.5rem !important} .text-center{ text-align: center !important} .text-nowrap{ white-space: nowrap !important} .text-danger{ --bs-text-opacity: 1; color: rgba(var(--bs-danger-rgb), var(--bs-text-opacity)) !important} .text-white{ --bs-text-opacity: 1; color: rgba(var(--bs-white-rgb), var(--bs-text-opacity)) !important} .bg-dark{ --bs-bg-opacity: 1; background-color: rgba(var(--bs-dark-rgb), var(--bs-bg-opacity)) !important} .bg-white{ --bs-bg-opacity: 1; background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) !important} @media (min-width:768px){ .d-md-inline{ display: inline !important}} @media (min-width:1200px){ .container{ max-width: 1140px} .d-xl-none{ display: none !important}} #website-navbar{ box-shadow: 0 .5rem 1rem rgba(0, 0, 0, .15); font-family: Roboto Condensed} #website-navbar .navbar-nav{ align-items: stretch; display: flex; flex-wrap: nowrap; margin-top: 1rem; width: 100%} #website-navbar .navbar-nav .nav-item{ align-items: stretch; flex-grow: 1; justify-content: center; line-height: 1.25rem} #website-navbar .navbar-nav .nav-link{ align-items: center; display: flex; flex-direction: column; font-size: .875rem; justify-content: center; padding: .5rem 1rem; text-align: center; text-transform: uppercase} #website-navbar .navbar-nav .nav-link.active{ background-color: #55524c; text-decoration: none} #navbar-left-wrapper{ background-color: #2a2926; box-shadow: 2px 0 1px rgba(0, 0, 0, .12), 1px 0 1px rgba(0, 0, 0, .24); display: none; height: 100%; padding-right: 0; position: fixed; top: 72px; width: 14.375rem; z-index: 9999; z-index: 2} #navbar-left-wrapper #navbar-left-collapse{ display: none} #navbar-left-wrapper~.container{ padding-left: 14.375rem} @media (min-width:992px){ .d-lg-none{ display: none !important} .px-lg-0{ padding-left: 0 !important; padding-right: 0 !important} #website-navbar{ box-shadow: 0 2px 1px rgba(0, 0, 0, .12), 0 1px 1px rgba(0, 0, 0, .24)} #website-navbar .navbar-nav{ margin-top: 0} #website-navbar .navbar-nav .nav-link{ font-size: .8125rem; height: 100%; padding-left: .75rem; padding-right: .75rem} #website-navbar .navbar-brand{ font-size: 1.0625rem; margin-bottom: 0} #navbar-left-wrapper{ display: block}} @media (max-width:991.98px){ #navbar-left-toggler-wrapper{ display: inline-block; top: 4.75rem; width: 54px; z-index: 1 !important} #navbar-left-wrapper #navbar-left-collapse{ display: block} #navbar-left-wrapper~.container{ padding-left: 15px} .w3-animate-left{ -webkit-animation: .4s animateleft; animation: .4s animateleft; position: relative} @-webkit-keyframes animateleft{ 0%{ left: -14.375rem; opacity: 0} to{ left: 0; opacity: 1}} @keyframes animateleft{ 0%{ left: -14.375rem; opacity: 0} to{ left: 0; opacity: 1}}} #navbar-left{ background-color: #2a2926; box-shadow: 0 1px 0 #030303; color: #fff; position: relative; width: 100%; z-index: 100} #navbar-left .h4{ font-weight: 400} #navbar-left li{ margin: 0; padding: 0; width: inherit} #navbar-left>li>a{ background-color: #373632; border-bottom: 1px solid #151413; border-top: 1px solid #45433e; color: #fff; font-size: 13px; font-weight: 300; padding: 12px 20px 12px 18px; text-shadow: 1px 1px 0 #45433e} [data-simplebar]{ align-content: flex-start; align-items: flex-start; flex-direction: column; flex-wrap: wrap; justify-content: flex-start; position: relative} #share-wrapper{ height: 40px; position: absolute; right: 50px; top: 37px; transform: translateY(-50%); z-index: 1050} #share-wrapper ul{ left: calc(-50% + 22.5px); position: relative; width: 90px} #share-wrapper ul li{ width: 45px} #share-wrapper label, #share-wrapper li>a{ border-radius: 50%; color: #efefef; height: 2.5rem; overflow: hidden; text-decoration: none; width: 2.5rem} #share-wrapper label#share{ background: #4267b2; opacity: .75; position: relative; z-index: 14} #share-wrapper li>a#share-facebook{ background: #3b5998} #share-wrapper li>a#share-twitter{ background: #00acee} #share-wrapper li>a#share-pinterest{ background: #e4405f} #share-wrapper li>a#share-linkedin{ background: #0077b5} #share-wrapper li>a#share-reddit{ background: #ff4500} #share-wrapper li>a#share-google-bookmarks{ background: #4285f4} #share-wrapper li>a#share-mix{ background: #ff8226} #share-wrapper li>a#share-pocket{ background: #ee4056} #share-wrapper li>a#share-digg{ background: #2a2a2a} #share-wrapper li>a#share-blogger{ background: #fda352} #share-wrapper li>a#share-tumblr{ background: #35465c} #share-wrapper li>a#share-flipboard{ background: #c00} #share-wrapper li>a#share-hacker-news{ background: #f60} #share-wrapper li:first-child{ opacity: 0; transform: translateY(-30%); z-index: 13} #share-wrapper li:nth-child(2){ opacity: 0; transform: translateY(-30%); z-index: 12} #share-wrapper li:nth-child(3){ opacity: 0; transform: translateY(-30%); z-index: 11} #share-wrapper li:nth-child(4){ opacity: 0; transform: translateY(-30%); z-index: 10} #share-wrapper li:nth-child(5){ opacity: 0; transform: translateY(-30%); z-index: 9} #share-wrapper li:nth-child(6){ opacity: 0; transform: translateY(-30%); z-index: 8} #share-wrapper li:nth-child(7){ opacity: 0; transform: translateY(-30%); z-index: 7} #share-wrapper li:nth-child(8){ opacity: 0; transform: translateY(-30%); z-index: 6} #share-wrapper li:nth-child(9){ opacity: 0; transform: translateY(-30%); z-index: 5} #share-wrapper li:nth-child(10){ opacity: 0; transform: translateY(-30%); z-index: 4} #share-wrapper li:nth-child(11){ opacity: 0; transform: translateY(-30%); z-index: 3} #share-wrapper li:nth-child(12){ opacity: 0; transform: translateY(-30%); z-index: 2} #share-wrapper li:nth-child(13){ opacity: 0; transform: translateY(-30%); z-index: 1} #share-wrapper input~ul{ visibility: hidden} @media only screen and (min-width:992px){ #share-wrapper{ position: fixed; right: 0; top: 180px} #share-wrapper label#share{ right: -42px}} :target{ scroll-margin-top: 100px} html{ font-family: Roboto, -apple-system, BlinkMacSystemFont, Segoe UI, Helvetica Neue, Arial, sans-serif, Apple Color Emoji, Segoe UI Emoji, Segoe UI Symbol; min-height: 100%; position: relative} @media screen and (prefers-reduced-motion:reduce){ html{ overflow-anchor: none; scroll-behavior: auto}} body{ counter-reset: section} .h4, h1, h2, h3{ font-family: Roboto, -apple-system, BlinkMacSystemFont, Segoe UI, Helvetica Neue, Arial, sans-serif, Apple Color Emoji, Segoe UI Emoji, Segoe UI Symbol} h1{ color: #0e73cc; line-height: .9; margin-bottom: 2.5rem} h1:first-letter{ font-size: 2em} h2{ border-bottom: 2px solid #2a2926; color: #2a2926; margin-bottom: 3rem; padding: 1rem} h3{ color: #2a2926} .h4{ color: #55524c; font-weight: 300 !important} h3{ margin-bottom: 1.5rem} .h4{ margin-bottom: 1rem} a{ text-decoration: none} p.lead{ color: #7f7a72; font-weight: 400} code, code[class*=language], pre{ font-size: .75rem} pre>code[class*=language]{ padding-left: 0 !important; padding-right: 0 !important} code[class*=language]{ padding-left: .25rem !important; padding-right: .25rem !important} strong{ font-weight: 500} .form-code>pre:after, .output-code>pre:after{ background: #55524c; border-radius: 0 .25rem; color: #fff; font-family: Roboto; font-size: .8125rem; height: 24px; line-height: 24px; padding: 0 15px; position: absolute; right: 0; top: 0} .output-code{ position: relative} .output-code>pre:after{ content: "output-code"} .form-code>pre:after{ content: "form code"} .btn .icon-circle{ border-radius: 50%; display: inline-block; height: 1.40625rem; line-height: 1.40625rem; width: 1.40625rem} .has-separator{ display: block; margin-bottom: 3rem; position: relative} .has-separator:after, .has-separator:before{ background: #d4d1cc; content: ""; height: 1px; left: 50%; position: absolute} .has-separator:before{ bottom: -1em; margin-left: -6%; width: 12%} .has-separator:after{ bottom: -1.1875em; margin-left: -10%; width: 20%} #search-bar #search-results-count{ left: -5.75rem; line-height: 22.5px; margin-right: -5.75rem; padding: .375rem 0; position: relative; width: calc(5.75rem + 1px); z-index: 3} .bi:before, [class*=" bi-"]:before{ -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; display: inline-block; font-family: bootstrap-icons !important; font-style: normal; font-variant: normal; font-weight: 400 !important; line-height: 1; text-transform: none; vertical-align: -.125em} .bi-arrow-down:before{ content: "\f128"} .bi-arrow-up:before{ content: "\f148"} .bi-share-fill:before{ content: "\f52d"} .bi-x:before{ content: "\f62a"} .bi-currency-dollar:before{ content: "\f636"} .bi-x-lg:before{ content: "\f659"} code[class*=language-], pre[class*=language-]{ color: #ccc; background: 0 0; font-family: Consolas, Monaco, 'Andale Mono', 'Ubuntu Mono', monospace; font-size: .8125rem; text-align: left; white-space: pre; word-spacing: normal; word-break: normal; word-wrap: normal; line-height: 1.5; -moz-tab-size: 4; -o-tab-size: 4; tab-size: 4; -webkit-hyphens: none; -moz-hyphens: none; -ms-hyphens: none; hyphens: none} pre[class*=language-]{ padding: 1em; margin: .5em 0; overflow: auto} pre[class*=language-]{ background: #2d2d2d} pre[class*=language-].line-numbers{ position: relative; padding-left: 3.8em; counter-reset: linenumber} pre[class*=language-].line-numbers>code{ position: relative; white-space: inherit} </style>
    <?php require_once 'inc/css-includes.php'; ?>
    <?php
    $form->printIncludes('css');
    ?>
</head>

<body style="padding-top:76px;" data-bs-spy="scroll" data-bs-target="#navbar-left-wrapper" data-bs-offset="180">

    <!-- Discount -->

    <div id="discount"></div>

    <!-- Main navbar -->

    <nav id="website-navbar" class="navbar navbar-dark bg-dark navbar-expand-lg px-2 px-lg-0 fixed-top">

        <div class="container-fluid px-0">
            <a class="navbar-brand me-3" href="../"><img src="assets/images/phpformbuilder-logo.png" width="60" height="60" class="me-3" alt="PHP Form Builder" title="PHP Form Builder">PHP Form Builder</a>
            <button class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#navcol-1"><span class="visually-hidden">Toggle navigation</span><span class="navbar-toggler-icon"></span></button>

            <div class="collapse navbar-collapse" id="navcol-1">

                <ul class="nav navbar-nav ms-auto">

                    <!-- https://www.phpformbuilder.pro navbar -->

                    <li class="nav-item"><a class="nav-link" href="../">Home</a></li>
                    <li class="nav-item"><a class="nav-link" href="../drag-n-drop-form-builder/index.php">Drag &amp; drop Form Builder</a></li>
                    <li class="nav-item"><a class="nav-link" href="quick-start-guide.php">Quickstart Guide</a></li>
                    <li class="nav-item"><a class="nav-link" href="../templates/index.php">Form Templates</a></li>
                    <li class="nav-item"><a class="nav-link" href="javascript-plugins.php">JavaScript plugins</a></li>
                    <li class="nav-item"><a class="nav-link active" href="code-samples.php">Code Samples</a></li>
                    <li class="nav-item"><a class="nav-link" href="class-doc.php">Class Doc.</a></li>
                    <li class="nav-item"><a class="nav-link" href="functions-reference.php">Functions Reference</a></li>
                    <li class="nav-item"><a class="nav-link" href="help-center.php">Help Center</a></li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main sidebar -->

    <div id="navbar-left-toggler-wrapper" class="navbar-light fixed-top p-2 d-lg-none d-xl-none">
        <button id="navbar-left-toggler" class="navbar-toggler bg-white"><span class="visually-hidden">Toggle navigation</span><span class="navbar-toggler-icon"></span></button>
    </div>

    <div id="navbar-left-wrapper" class="w3-animate-left pb-6" data-simplebar>
        <a href="#" id="navbar-left-collapse" class="d-flex justify-content-end d-lg-none d-xl-none text-white p-4"><i class="bi bi-x-lg"></i></a>
        <ul id="navbar-left" class="nav nav-pills flex-column pt-1 mb-4">
            <?php buildLeftNav($sections); ?>
        </ul>
    </div>

    <!-- /main sidebar -->

    <main class="container">

        <?php include_once 'inc/top-section.php'; ?>

        <h1 id="home">Code Samples<br><small>Examples of use with the source code and the resulting HTML</small></h1>
        <?php buildContent($sections, $contentText, $phpCode, $output, $outputCode); ?>
    </main>
    <!-- container -->
    <?php require_once 'inc/js-includes.php'; ?>
</body>

</html>
